;	CALLEXT, LOADEXT sample external routine
;
;	This file is written in Microsoft Macro Assembler
;	Use the following commands to compile and link:
;
;		MASM GETKEY;
;		LINK GETKEY,GETKEY.OVL;
;
;	Ignore the no stack segment warning.
;
	TITLE   getkey.c

_TEXT	SEGMENT  WORD PUBLIC 'CODE'
_TEXT	ENDS
_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS

_TEXT      SEGMENT
	ASSUME	CS: _TEXT, DS: _DATA

_DATA	SEGMENT
sound   dw	0
keylen	dw	0
_DATA	ENDS

; ==================================================

upcase  PROC    NEAR

        cmp     al,'a'
        jb      upcdone
        cmp     al,'z'
        ja      upcdone
        sub     al,32
upcdone:
        ret

upcase  ENDP

;======================================

beep	proc	near

	cmp	sound,0
	jnz	beepx

	ret
beepx:
	in	al,61h
	push	ax

	mov	dx,0bh
main:	mov	bx,477

	mov	al,10110110b
	out	43h,al
	mov	ax,bx
	out	42h,al
	mov	al,ah
	out	42h,al
	in	al,61h
	or	al,00000011b
	out	61h,al

	mov	cx,2600h
delay1:
	loop	delay1

	mov	bx,36

	mov	al,10110110b
	out	43h,al
	mov	ax,bx
	out	42h,al
	mov	al,ah
	out	42h,al
	in	al,61h
	or	al,00000011b
	out	61h,al

	mov	cx,1300h
delay2:
	loop	delay2

	dec	dx
	jnz	main

	pop	ax
	out	61h,al

	ret

beep	endp

;===========================================

_keychk	PROC	FAR

; This subroutine accepts two arguments
; The first argument is an integer value.  If the value is 0
; subroutine "beep" will be called on error.
; The second argument is an ASCIIZ string.  The characters in
; the input string are the acceptable input keys.  On return,
; the ASCIIZ string will be modified to a one byte string which
; has the key entered in this subroutine.

	push	es
	push	ds
	push	di
	push	si
	push	bp
	mov	bp,sp

	mov	ax,_DATA
	mov	ds,ax

	mov	ax,[bp+18]
	mov	sound,ax

	les	bx,[bp+14]
	mov	cl,es:[bx]
	inc	bx
	xor	ch,ch
	mov	[keylen],cx

chkkey:
	mov	ah,0
	int	16h

	cmp	al,0
	jnz	normal

	xchg	al,ah
	or 	al,128

normal:
	xor	ah,ah
	call	upcase

	mov	cx,[keylen]
	les	bx,[bp+14]
	inc	bx
chkkeys:
	cmp	byte ptr es:[bx],al
	jz	fini
	inc	bx
	loop	chkkeys

	call	beep

	jmp	chkkey

fini:
	les	bx,[bp+14]
	mov	byte ptr es:[bx],1
	inc	bx
	mov	es:[bx],ax

	pop	bp
	pop	si
	pop	di
	pop	ds
	pop	es

	ret

_keychk	ENDP

;======================================

_TEXT	ENDS

	END	_keychk
